﻿using System;
using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class LeaderboardController : MonoBehaviour
{

    [SerializeField]
    private TMP_Text highScore1_display;
    [SerializeField]
    private TMP_Text highScore2_display;
    [SerializeField]
    private TMP_Text highScore3_display;
    [SerializeField]
    private TMP_Text highScore4_display;
    [SerializeField]
    private TMP_Text highScore5_display;
    [SerializeField]
    private TMP_Text highScore6_display;

    private TMP_Text[] displayArray;
    private string[] textArray ;
    private float[] timeArray;
    private TimeSpan[] timespanArray;

    // Start is called before the first frame update
    void OnEnable()
    {
        displayArray = new TMP_Text[6] { highScore1_display, highScore2_display, highScore3_display, highScore4_display, highScore5_display, highScore6_display };
        textArray = new string[6];
        timeArray = new float[6];
        timespanArray = new TimeSpan[6];

        RefreshLeaderboard();
    }

    private void RefreshLeaderboard()
    {
        for (int i = 0; i < textArray.Length; i++)
        {
            timeArray[i] = PlayerPrefs.GetFloat("HighScore" + (i+1).ToString());
            if (timeArray[i] != 0.0f)
            {
                timespanArray[i] = TimeSpan.FromSeconds(timeArray[i]);
                textArray[i] = "HIGH SCORE " + (i+1).ToString() + " : " + timespanArray[i].ToString("m':'ss'.'fff");
                displayArray[i].text = textArray[i];
            }
            else
            {
                textArray[i] = "HIGH SCORE " + (i+1).ToString() + " : -:--.---";
                displayArray[i].text = textArray[i];
            }
        }
    }

    public void ClearLeaderboard()
    {
        for (int i = 1; i <= 6; i++)
        {
            PlayerPrefs.DeleteKey("HighScore" + i.ToString());
        }
        RefreshLeaderboard();
    }
}
